package music.lists;

import java.util.LinkedList;

import music.Song;

public class Playlist {
	
	private LinkedList<Song> songs;

	public Playlist(LinkedList<Song> songs) {
		super();
		this.songs = songs;
	}

	public Playlist() {
		super();
		songs = new LinkedList<Song>();
	}
	
	public void addSong(Song song) {
		songs.add(song);
	}
	
	public void removeSong() {
		songs.remove();
	}
	
	public void removeSong(Song song) {
		songs.remove(song);
		
	}
	
	public void pushSong(Song song) {
		songs.push(song);
	}
	
	public void popSong() {
		songs.pop();
	}
	
	public void playAll() {
		for (int i = 0; i < songs.size(); i++) {
			songs.get(i).display();
		}
	}

	public LinkedList<Song> getSongs() {
		return songs;
	}

	public void setSongs(LinkedList<Song> songs) {
		this.songs = songs;
	}

}
